﻿using System;
using System.Drawing.Printing;
using System.IO;
using System.Linq;
using System.Windows.Forms;
using System.Diagnostics;
using System.Printing;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSFB.Constants;
using iTextSharp.text;
using iTextSharp.text.pdf;
using iTextSharp.awt;
using iTextSharp.xmp;
using iTextSharp.text.html.simpleparser;

namespace AZVIC.Ei8htPOS.POSFB.Helper
{
    public static class PDFHelper
    {
        private const float tWidth = 275f;
        private static float remainingPageSpace;

        public static void GenerateInvoicePDF(Guid ordersID)
        {
            Orders currOrder = OrdersBL.GetItem(ordersID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            UserAccount adminAccount = UserAccountBL.GetItem(currOrder.AdminUserAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            MemoryStream output;

            using (output = new MemoryStream())
            {
                Document myDocument = new Document(PageSize.B7, 0f, 0f, 25f, 2f);
                FileStream fs = new FileStream(Path.GetTempPath() + Constants.Controls.PDF_SILENTPRINT, FileMode.OpenOrCreate);
                PdfWriter writer = PdfWriter.GetInstance(myDocument, fs);
                PageEventHelper pageEventHelper = new PageEventHelper();
                writer.PageEvent = pageEventHelper;
                myDocument.Open();
                myDocument.NewPage();

                PdfPCell pCell = null;
                PdfPTable pTable = new PdfPTable(1);

                #region Adding Header
                Paragraph para;
                string address = string.Empty;
                float[] widths = new float[] { };

                myDocument.Add(AddHeader());
                #endregion

                //#region Adding Invoice & GST Caption
                //pTable = new PdfPTable(1);
                //pTable.TotalWidth = tWidth;
                //pTable.LockedWidth = true;

                //para = new Paragraph("RECEIPT\n", new Font(Font.FontFamily.HELVETICA, 12f, Font.BOLD, BaseColor.BLACK));
                //para.Alignment = Element.ALIGN_CENTER;
                //pCell = new PdfPCell(para);
                //pCell.Border = Rectangle.NO_BORDER;
                //pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                //pCell.VerticalAlignment = Element.ALIGN_TOP;
                //pTable.AddCell(pCell);

                //myDocument.Add(pTable);
                //#endregion

                //for (int curItem = 0; curItem < currOrder.OrdersDetailsList.Count; curItem++)
                //{

                //    #region Items Table

                //    pTable = new PdfPTable(3);
                //    pTable.TotalWidth = tWidth;
                //    pTable.LockedWidth = true;
                //    widths = new float[] { 2.0f, .4f, .6f };
                //    pTable.SetWidths(widths);

                //    para = new Paragraph(currOrder.OrdersDetailsList[curItem].ProductName, new Font(Font.FontFamily.HELVETICA, 11f, Font.NORMAL, BaseColor.BLACK));
                //    para.Alignment = Element.ALIGN_LEFT;
                //    pCell = new PdfPCell(para);
                //    pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                //    pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                //    pCell.PaddingBottom = 5f;
                //    pTable.AddCell(pCell);

                //    para = new Paragraph(currOrder.OrdersDetailsList[curItem].Quantity.ToString(), new Font(Font.FontFamily.HELVETICA, 11f, Font.NORMAL, BaseColor.BLACK));
                //    para.Alignment = Element.ALIGN_CENTER;
                //    pCell = new PdfPCell(para);
                //    pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                //    pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                //    pCell.PaddingBottom = 5f;
                //    pTable.AddCell(pCell);

                //    para = new Paragraph(currOrder.OrdersDetailsList[curItem].Amount.ToString("0.00"), new Font(Font.FontFamily.HELVETICA, 11f, Font.NORMAL, BaseColor.BLACK));
                //    para.Alignment = Element.ALIGN_RIGHT;
                //    pCell = new PdfPCell(para);
                //    pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                //    pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                //    pCell.PaddingBottom = 5f;
                //    pTable.AddCell(pCell);

                //    myDocument.Add(pTable);
                //    #endregion
                //}

                //remainingPageSpace = writer.GetVerticalPosition(false);

                //#region Total Column

                //pTable = new PdfPTable(3);
                //pTable.TotalWidth = tWidth;
                //pTable.LockedWidth = true;
                //widths = new float[] { 2.0f,0.4f,0.6f };

                //pTable.SetWidths(widths);

                //para = new Paragraph("Sub Total:\nDiscount:\nService Tax\nGST:\nGrand Total:\n", new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                //para.Alignment = Element.ALIGN_RIGHT;
                //pCell = new PdfPCell(para);
                //pCell.SetLeading(1f, 1f);
                //pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                //pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                //pCell.PaddingBottom = 7f;
                //pTable.AddCell(pCell);

                //address = string.Format("{0}\n", currOrder.SubTotal.ToString("0.00")) +
                //    string.Format("{0}\n", currOrder.Discount.ToString("0.00")) +
                //    string.Format("{0}\n", ((currOrder.SubTotal - currOrder.Discount) * .1M).ToString("0.00")) +
                //    string.Format("{0}\n", currOrder.GST.ToString("0.00")) +
                //    string.Format("{0}\n", currOrder.Total.ToString("0.00"));
 
                //para = new Paragraph(address, new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                //para.Alignment = Element.ALIGN_RIGHT;
                //pCell = new PdfPCell(para);
                //pCell.SetLeading(1f, 1f);
                //pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                //pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                //pCell.PaddingBottom = 7f;
                //pTable.AddCell(pCell);

                //myDocument.Add(pTable);

                //#endregion
                myDocument.Close();
            }

            #region Printing
            PrintPDF(Path.GetTempPath() + Constants.Controls.PDF_SILENTPRINT);
            File.Delete(Path.GetTempPath() + Constants.Controls.PDF_SILENTPRINT);
            #endregion
        }

        private static PdfPTable AddHeader()
        {
            PdfPTable pTable = new PdfPTable(1);       
            PdfPCell pCell = null;
            pTable.TotalWidth = tWidth;
            pTable.LockedWidth = true;
            float[] widths = new float[] { 1f };
            pTable.SetWidths(widths);
            
            iTextSharp.text.Image pic = iTextSharp.text.Image.GetInstance(new Uri("http://ei8htpos.com/Admin/Images/logo.png", UriKind.Absolute));//iTextSharp.text.Image.GetInstance(HttpContext.Current.Server.MapPath("~/Admin/Images/Logo.jpg"));

            pic.Alignment = Element.ALIGN_LEFT;
            pCell = new PdfPCell(pic);

            pCell.Border = Rectangle.NO_BORDER;
            pCell.HorizontalAlignment = Element.ALIGN_CENTER;
            pCell.VerticalAlignment = Element.ALIGN_TOP;
            PdfPRow pRow = new PdfPRow(new PdfPCell[] { pCell });
            pTable.Rows.Add(pRow);

            string address = AppSession.InvoiceAddress.Replace(@"\n", Environment.NewLine);
            Paragraph para = new Paragraph(address, new Font(Font.FontFamily.HELVETICA, 8f, Font.NORMAL, BaseColor.BLACK));
            para.Alignment = Element.ALIGN_CENTER;
            pCell = new PdfPCell(para);
            pCell.SetLeading(1f, 1.2f);
            pCell.Border = iTextSharp.text.Rectangle.NO_BORDER;
            pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
            pCell.VerticalAlignment = Element.ALIGN_TOP;
            pRow = new PdfPRow(new PdfPCell[] { pCell });
            pTable.Rows.Add(pRow);

            para = new Paragraph("\n ", new Font(Font.FontFamily.HELVETICA, 8f, Font.NORMAL, BaseColor.BLACK));
            para.Alignment = Element.ALIGN_CENTER;
            pCell = new PdfPCell(para);
            pCell.SetLeading(1f, 1.2f);
            pCell.Border = iTextSharp.text.Rectangle.NO_BORDER;
            pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
            pCell.VerticalAlignment = Element.ALIGN_TOP;
            pRow = new PdfPRow(new PdfPCell[] { pCell });
            pTable.Rows.Add(pRow);

            return pTable;
        }

        private static PdfPTable AddLeadingSpaces()
        {
            PdfPTable pTable = new PdfPTable(1);
            Paragraph para = new Paragraph("\n  ", new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
            para.Alignment = Element.ALIGN_CENTER;
            PdfPCell pCell = new PdfPCell(para);
            pCell.Border = Rectangle.NO_BORDER;
            pCell.HorizontalAlignment = Element.ALIGN_CENTER;
            pCell.VerticalAlignment = Element.ALIGN_TOP;
            pTable.AddCell(pCell);
            return pTable;
        }

        private static void PrintPDF(string fileName, bool isSecondTime= false)
        {
            while (AppSession.CheckPrinterAssigned())
            {
                try
                {
                    Spire.Pdf.PdfDocument doc = new Spire.Pdf.PdfDocument();

                    string pdfFile = fileName;
                    //load PDF document
                    doc.LoadFromFile(pdfFile);

                    //Spire.Pdf.Graphics.PdfMargins margin = new Spire.Pdf.Graphics.PdfMargins();
                    //margin.Top = 2f;
                    //margin.Bottom = margin.Top;
                    //margin.Left = 1f;
                    //margin.Right = margin.Left;

                    //doc.PageSettings.Size = new System.Drawing.SizeF(827f, 1169f);
                    //doc.PageSettings.Margins = margin;
                    //doc.PageSettings.Orientation = Spire.Pdf.PdfPageOrientation.Portrait;

                    //Default printing mode without interaction (default printer to print all pages of the document)
                    //doc.PrintDocument.Print();
                    //Interaction printing mode(page range,printer,and properties of printing can be freely to selected and set)
                    PrintDialog dialogPrint = new PrintDialog();
                    
                    //dialogPrint.PrinterSettings.DefaultPageSettings.PaperSize = new PaperSize("A4", 595, 842);
                    
                    dialogPrint.AllowPrintToFile = true;
                    dialogPrint.AllowSomePages = true;
                    dialogPrint.PrinterSettings.MinimumPage = 1;
                    dialogPrint.PrinterSettings.MaximumPage = doc.Pages.Count;
                    dialogPrint.PrinterSettings.FromPage = 1;
                    dialogPrint.PrinterSettings.ToPage = doc.Pages.Count;
                    
                    //if (dialogPrint.ShowDialog() == DialogResult.OK)
                    //{
                    //the startpage was selected to be printed
                    doc.PrintFromPage = dialogPrint.PrinterSettings.FromPage;
                    //the endpage was selected to be printed
                    doc.PrintToPage = dialogPrint.PrinterSettings.ToPage;
                    //Choose printer to print pdf document

                    doc.PrinterName = Properties.Settings.Default.InvoicePrinter;
                    PrintDocument printDoc = doc.PrintDocument;

                    dialogPrint.Document = printDoc;
                    //Realize printing
                    printDoc.Print();
                    //}

                    break;
                }
                catch(Exception ex)
                {
                    if (!isSecondTime) PrintPDF(fileName, true);
                }
            }
        }

        public class PageEventHelper : PdfPageEventHelper
        {
            PdfContentByte cb;
            PdfTemplate template;

            Font RunDateFont = FontFactory.GetFont("helvetica", 10f, Font.NORMAL, BaseColor.BLACK);

            public override void OnOpenDocument(PdfWriter writer, Document document)
            {
                //cb = writer.DirectContent;
                //template = cb.CreateTemplate(50, 50);
            }

            public override void OnEndPage(PdfWriter writer, Document document)
            {
                //base.OnEndPage(writer, document);

                //int pageN = writer.PageNumber;
                //String text = "Page " + pageN.ToString() + " of ";
                //float len = this.RunDateFont.BaseFont.GetWidthPoint(text, this.RunDateFont.Size);

                //iTextSharp.text.Rectangle pageSize = document.PageSize;

                //cb.SetRGBColorFill(0, 0, 0);

                //cb.BeginText();
                //cb.SetFontAndSize(this.RunDateFont.BaseFont, this.RunDateFont.Size);
                //cb.SetTextMatrix(document.LeftMargin, pageSize.GetBottom(document.BottomMargin));
                //cb.ShowText(text + "      (This is a computer generated document and requires no signature.)     Powered By Azvic Enterprise Pte Ltd.");

                //cb.EndText();

                //cb.AddTemplate(template, document.LeftMargin + len, pageSize.GetBottom(document.BottomMargin));
            }

            public override void OnCloseDocument(PdfWriter writer, Document document)
            {
                //base.OnCloseDocument(writer, document);

                //template.BeginText();
                //template.SetFontAndSize(this.RunDateFont.BaseFont, this.RunDateFont.Size);
                //template.SetTextMatrix(0, 0);
                //template.ShowText("" + (writer.PageNumber - 1));
                //template.EndText();
            }
        }
    }
}
